import numpy as np
import scipy.sparse as sp
import torch

def to_scipy_sparse_matrix(edge_index, num_nodes: int):
    if isinstance(edge_index, torch.Tensor):
        ei = edge_index.detach().cpu().numpy()
    else:
        ei = np.asarray(edge_index)
    r, c = ei
    data = np.ones(r.size, dtype=np.float64)
    A = sp.coo_matrix((data, (r, c)), shape=(num_nodes, num_nodes)).tocsr()
    A = A.maximum(A.T); A.setdiag(0); A.eliminate_zeros()
    return A

def adj2edge(A: sp.coo_matrix):
    A = A.tocoo()
    row = torch.as_tensor(A.row, dtype=torch.long)
    col = torch.as_tensor(A.col, dtype=torch.long)
    edge_index = torch.stack([row, col], dim=0)
    edge_weight = torch.as_tensor(A.data, dtype=torch.float32)
    return edge_index, edge_weight

def scipy_to_torch_sparse(A: sp.csr_matrix, device="cpu", dtype=torch.float64):
    A = A.tocoo()
    import numpy as np
    idx = np.vstack([A.row, A.col])
    i = torch.from_numpy(idx).long().to(device)
    v = torch.from_numpy(A.data).to(device=device, dtype=dtype)
    return torch.sparse_coo_tensor(i, v, size=A.shape, device=device, dtype=dtype).coalesce()

def degree_from_csr(W: sp.csr_matrix):
    import numpy as np
    return np.asarray(W.sum(axis=1)).ravel()

def symmetrize_simple(W: sp.csr_matrix):
    W = W.maximum(W.T); W.setdiag(0); W.eliminate_zeros(); return W

